@extends('layout.master')
@section('content')

<main id="js-page-content" role="main" class="page-content">
    <div class="row">
        <div class="col-md-11">
            <div class="subheader">
                <h1 class="subheader-title">
                    <i class="subheader-icon fal fa-table"></i> Brands
                    <small>
                        Create, Update Brands Here
                    </small>
                     
                </h1>
            </div>
        </div>
        <div class="col-md-1" align="center">
            @if(Session::get('usertype') == 1)
            <button type="button" class="btn btn-success waves-effect waves-themed" data-toggle="modal" data-target="#addbrandModal" ><i class="fa-2x ni ni-big-plus"></i></button>
            @else
            @endif
        </div>
    </div>
    
    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        Records
                    </h2>
                    <div class="panel-toolbar">
                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table Style</button>
                        <div class="dropdown-menu dropdown-menu-animated dropdown-menu-right position-absolute pos-top">
                            <button class="dropdown-item active" data-action="toggle" data-class="table-bordered" data-target="#dt-basic-example">Bordered Table</button>
                            <button class="dropdown-item" data-action="toggle" data-class="table-sm" data-target="#dt-basic-example">Smaller Table</button>
                            <button class="dropdown-item" data-action="toggle" data-class="table-dark" data-target="#dt-basic-example">Table Dark</button>
                            <button class="dropdown-item active" data-action="toggle" data-class="table-hover" data-target="#dt-basic-example">Table Hover</button>
                            <button class="dropdown-item active" data-action="toggle" data-class="table-stripe" data-target="#dt-basic-example">Table Stripped</button>
                            <div class="dropdown-divider m-0"></div>
                        </div>
                    </div>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <!-- datatable start -->
                        <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Url</th>
                                    <th>Type</th>
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 3)
                                    <th>Manager</th>
                                    @else
                                    <th>Agent</th>
                                    @endif
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 3 || Session::get('usertype') == 2)
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>

                                @if(count($brands) > 0)
                                @foreach($brands as $row)
                                <tr>
                                    <td>{{ $row['brand_id'] }}</td>
                                    <td>{{ $row['brand_name'] }}</td>
                                    <td>{{ $row['brand_url'] }}</td>
                                    <td>{{ $row['brand_type'] }}</td>
                                    <td>
                                        @if(count($row['assign_managers']) > 0)
                                        @foreach($row['assign_managers'] as $rows)
                                            <img src="{{ asset('public/backend/img/users') }}/{{ $rows->image }}" class="agentimamges" width="30" height="30" title="{{ $rows->first_name }} {{ $rows->last_name }}" data-toggle="tooltip" data-placement="top" data-original-title="Tooltip on top" data-manager="{{ $rows->manager_id }}">
                                        @endforeach
                                        @else
                                        Nil
                                        @endif 
                                    </td>
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 3 || Session::get('usertype') == 2)
                                    <td class="text-nowrap">
                                        
                                        <button type="button" class="btn btn-info waves-effect waves-themed btnSelect"  data-toggle="modal" data-target="#edit-modal" data-action="edit" data-rowid="{{ $row['brand_id'] }}"><i class="ni ni-note"></i></button>
                                         <!-- |
                                        <button type="button" class="btn btn-danger waves-effect waves-themed btnSelect" data-action="delete" data-rowid="{{ $row['brand_id'] }}"><i class="ni ni-trash"></i></button> -->
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                                @else

                                    <!-- <h4 align="center" class="no-record">No Record</h4> -->

                                @endif

                                </tbody>
                            <tfoot>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Url</th>
                                    <th>Type</th>
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 3)
                                    <th>Manager</th>
                                    @else
                                    <th>Agent</th>
                                    @endif
                                    @if(Session::get('usertype') == 1 || Session::get('usertype') == 3 || Session::get('usertype') == 2)
                                    <th>Action</th>
                                    @endif
                                </tr>
                            </tfoot>
                        </table>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
@if(Session::get('usertype') == 1 || Session::get('usertype') == 3 || Session::get('usertype') == 2)
<div class="modal fade" id="addbrandModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success-900">
                <h4 class="modal-title">
                    Add Brand
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form class="form-material m-t-40" method="POST" action="{{ route('add_brands') }}">
                @csrf
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" name="name" value="" placeholder="Brand Name" required>
                    </div>
                    <div class="form-group">
                        <label>URL</label>
                        <input type="url" class="form-control" name="url" value="" placeholder="www.staffshaw.com" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Type</label>
                        <select class="form-control" name="brand_type">
                            <option value="">Select Type</option>
                            <option value="Design">Design</option>
                            <option value="Content">Content</option>
                        </select>
                    </div>

                    <div class="row mb-5">
                        <div class="col-md-12">
                            <p>Assign Managers </p>
                            @if(count($depart_managers) > 0)
                            @foreach($depart_managers as $row)
                            <div class="d-flex p-1">
                                <div class="">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="{{ $row->id }}" name="depart_manager[]" value="{{ $row->id }}" />
                                        <label class="custom-control-label" for="{{ $row->id }}"></label>
                                    </div>
                                </div>
                                <div class="">
                                    {{ $row->first_name }} {{ $row->last_name }}
                                </div>
                                <div class=" flex-grow-1" align="right">
                                    <span class="badge bg-danger-900 bg-info-gradient fw-500 l-h-n">
                                        {{ $row->name }}
                                    </span>
                                </div>
                            </div>
                            @endforeach
                            @else
                            <div class="alert alert-danger" role="alert">
                                <strong>Oh snap!</strong> No record
                            </div>
                            @endif
                        </div>
                    </div>


                    <input type="hidden" name="id" value="{{ Session::get('id') }}">
                    <div class="row">
                        <div class="col-md-12" align="center">
                            <button type="submit" class="btn btn-primary ">Add Brand</button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info-900">
                <h4 class="modal-title">
                    Edit Brand
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('update_brands') }}">
                        @csrf
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control brandname" name="brandname" placeholder="Brand Name">
                        </div>
                        <div class="form-group">
                            <label>URL</label>
                            <input type="url" class="form-control brandurl" name="brandurl" placeholder="www.staffshaw.com">
                        </div>
                        
                        <div class="form-group">
                            <label>Type</label>
                            <select class="form-control brandtype" name="brandtype">
                                <option value="">Select Type</option>
                                <option value="Design">Design</option>
                                <option value="Content">Content</option>
                            </select>
                        </div>

                        <div class="row mb-5">
                            <div class="col-md-12">
                                <p>Assign Managers </p>
                                @if(count($depart_managers) > 0)
                                @foreach($depart_managers as $row)
                                <div class="d-flex p-1">
                                    <div class="">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input user-edit" id="edit{{ $row->id }}" name="depart_manager[]" value="{{ $row->id }}" />
                                            <label class="custom-control-label" for="edit{{ $row->id }}"></label>
                                        </div>
                                    </div>
                                    <div class="">
                                        {{ $row->first_name }} {{ $row->last_name }}
                                    </div>
                                    <div class=" flex-grow-1" align="right">
                                        <span class="badge bg-danger-900 bg-info-gradient fw-500 l-h-n">
                                            {{ $row->name }}
                                        </span>
                                    </div>
                                </div>
                                @endforeach
                                @else
                                <div class="alert alert-danger" role="alert">
                                    <strong>Oh snap!</strong> No record
                                </div>
                                @endif
                            </div>
                        </div>

                        <input type="hidden" name="editsenderid" value="{{ Session::get('id') }}">
                        <input type="hidden" name="editbrandid" value="" class="editbrandid">
                        <div class="row">
                            <div class="col-md-12" align="center">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>

                    </form>
            </div>
        </div>
    </div>
</div>



<div id="deletebrandModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-confirm modal-dialog-centered">
        <div class="modal-content">
            <!-- <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div> -->
            <div class="modal-body" align="center">
                <img src="{{ asset('public/assets/images/close.png') }}" width="70" height="70">
                <h4 class="modal-title" style="color: #636363; margin-top: 10px;">Are you sure?</h4>
                <p style="color: #999999">Do you really want to delete this records?</p>
                <form method="POST" action="{{ route('delete_brands') }}">
                    @csrf
                    <input type="hidden" name="deletebrandid" class="deletebrandid" id="deleteleadblastid">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-info" data-dismiss="modal">Cancel</button>
                </form>
            </div>
            <!-- <div class="modal-footer" align="center">

            </div> -->
        </div>
    </div>
</div>

@endif

@endsection

@section('page_script')
<script type="text/javascript">

    $(document).ready(function(){

        // code to read selected table row cell data (values).
        $("#dt-basic-example").on('click','.btnSelect',function(){

            var action = $(this).data('action');
            var rowid = $(this).data('rowid');

            if(action == 'edit'){

                $('.user-edit').each(function(){
                        $(this).removeAttr('checked');
                        
                });
                // get the current row
                var currentRow = $(this).closest("tr");

                var brandname = currentRow.find("td:eq(1)").text();
                var brandurl = currentRow.find("td:eq(2)").text();
                var brandtype = currentRow.find("td:eq(3)").text();
                var brandusers = currentRow.find("td:eq(4)").find('.agentimamges').data('manager');
            

                $(currentRow.find("td:eq(4)").find('.agentimamges')).each(function(index,value){
                    var imgdata = $(value).data('manager');
                    $('.user-edit').each(function(){
                        if($(this).val() == imgdata){
                            $(this).attr('checked','checked');
                        }
                    });
                });
                

                $('.brandname').val(brandname);
                $('.brandurl').val(brandurl);
                $('.brandtype').find('option[value="' + brandtype + '"]').attr("selected", true);
                $('.editbrandid').val(rowid);

                $('#edit-modal').modal('show');
            }
            else{
                $('.deletebrandid').val(rowid);
                $('#deletebrandModal').modal('show');
            }

        });
    });

</script>



<script>
            /* demo scripts for change table color */
            /* change background */


            $(document).ready(function()
            {
                $('#dt-basic-example').dataTable(
                {
                    responsive: true
                });

                $('.js-thead-colors a').on('click', function()
                {
                    var theadColor = $(this).attr("data-bg");
                    console.log(theadColor);
                    $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
                });

                $('.js-tbody-colors a').on('click', function()
                {
                    var theadColor = $(this).attr("data-bg");
                    console.log(theadColor);
                    $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
                });


            });

</script>

@endsection